#version 140
#extension GL_EXT_gpu_shader4 : enable
// Burning Forest FractalMod01.fsh by c0rymcg
//https://www.shadertoy.com/view/NdXfzB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159
#define TAU 6.28318
#define maxIterations 30
#define AA 2


vec2 cMult(vec2 c1, vec2 c2){
   //complex mult
    float newR = c1.x*c2.x - c1.y*c2.y;
	float newI = c1.y*c2.x + c1.x*c2.y;
	return vec2(newR,newI);
}
vec2 cDivide(vec2 c1, vec2 c2){
	//conjugate = a - bi;
	//to divide, multiply both sides by complex conjugate of denom

	float divisor = dot(c2,c2);
	
	return vec2((c1.x*c2.x + c1.y*c2.y)/divisor, (c1.y*c2.x - c1.x*c2.y)/divisor);
}


vec2 f1(vec2 z, vec2 c) {
    
    return cDivide(vec2(abs(z.x),abs(z.y)),vec2(abs(c.x),abs(c.y)))+c;
}

vec3 palette(float loc, vec3 a, vec3 b, vec3 c, vec3 d) {
    return a + b*cos( TAU*(c*loc+d) );
}

float logPotential(float d,float i){
  
	float base=log(2.);
	return i-(log(log(d)/base)/base);

}

//--------------------------------------------------------------------------------
float CatmullRom(float x, float v0,float v1, float v2,float v3) 
{
	float c2 = -.5 * v0	+ 0.5*v2;
	float c3 = v0		+ -2.5*v1 + 2.0*v2 + -.5*v3;
	float c4 = -.5 * v0	+ 1.5*v1 + -1.5*v2 + 0.5*v3;
	return(((c4 * x + c3) * x + c2) * x + v1);
	
}

vec2 p1 = vec2(-0.8,-0.2);
vec2 p2 = vec2(-0.5,0.1);
vec2 p3 = vec2(-0.45,0.4);
vec2 p4 = vec2(-0.7,0.55);
vec2 p5 = vec2(0.1,0.9);
vec2 p6 = vec2(-0.5,0);
vec2 p7 = vec2(-0.51,-0.75);
vec2 p8 = vec2(-0.75,-0.45);



vec2 calcjPos(float time){
    
    float phase = mod(time*8.,8.);
    float x = fract(phase);
    phase = floor(phase);
    
    vec2 result = vec2(0);
    if(phase>=7.){
        result.x = CatmullRom(x,p7.x,p8.x,p1.x,p2.x);
        result.y = CatmullRom(x,p7.y,p8.y,p1.y,p2.y);
    }else if(phase>=6.){
        result.x = CatmullRom(x,p6.x,p7.x,p8.x,p1.x);
        result.y = CatmullRom(x,p6.y,p7.y,p8.y,p1.y);
    }else if (phase>=5.){
        result.x = CatmullRom(x,p5.x,p6.x,p7.x,p8.x);
        result.y = CatmullRom(x,p5.y,p6.y,p7.y,p8.y);
    }else if (phase>=4.){
        result.x = CatmullRom(x,p4.x,p5.x,p6.x,p7.x);
        result.y = CatmullRom(x,p4.y,p5.y,p6.y,p7.y);
    }else if (phase>=3.){
        result.x = CatmullRom(x,p3.x,p4.x,p5.x,p6.x);
        result.y = CatmullRom(x,p3.y,p4.y,p5.y,p6.y);
    }else if (phase>=2.){
        result.x = CatmullRom(x,p2.x,p3.x,p4.x,p5.x);
        result.y = CatmullRom(x,p2.y,p3.y,p4.y,p5.y);
        
    }else if (phase>=1.){
        result.x = CatmullRom(x,p1.x,p2.x,p3.x,p4.x);
        result.y = CatmullRom(x,p1.y,p2.y,p3.y,p4.y);
        
    }else{
        result.x = CatmullRom(x,p8.x,p1.x,p2.x,p3.x);
        result.y = CatmullRom(x,p8.y,p1.y,p2.y,p3.y);
        
    }
    return result;
    
    
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
    vec3 aacol=vec3(0.);
    float time = iTime;
    
    vec2 jPos = calcjPos(iTime/60.);//vec2(-0.8+cos(iTime/3.)*0.1,cos(iTime/4.)*0.4-0.3);
    
    //aa code here
    for (int aax=0; aax<AA; aax++){
    for (int aay=0; aay<AA; aay++){
        
        
        vec2 uv = (gl_FragCoord.xy + vec2(aax,aay)/float(AA))/iResolution.xx;
        uv -= 0.5;uv *= 1.3;uv += 0.5;
        uv=3.*(uv-vec2(0.5,0.22));
        
         
        
        int i = 0;
         if(iMouse.z>0.){
            vec2 mPos = iMouse.xy/iResolution.xx;
            mPos -= 0.5; mPos *= 1.3; mPos += 0.5;
            mPos=3.*(mPos-vec2(0.5,0.22));
            jPos=mPos;
        }
        
        vec2 c=uv;
        c=jPos;
        vec2 z = uv;
        
        //iterate
        float sum=0.; float fmin=10000.; float fmax=0.; float lenz=0.;
        for (i = 0; i < maxIterations; i++) {
          z = f1(z,c);

          lenz = exp(0.-length(z));
          if (lenz<fmin) fmin=lenz;
          if (lenz>fmax) fmax=lenz;
          sum+=lenz;
          
        }

			//exp smoothing color method
	float colval = sqrt(sum)/(1.+fmax-fmin);

    
    vec3 iterationCol = vec3(palette(colval/2., vec3(0.5),vec3(0.5),vec3(1.0, 1.0, 0.0),vec3(0.3, 0.2, 0.2)));
    /* for debugging
    if (distance(jPos,uv)<0.02)iterationCol=vec3(0);
    
    float distToControls = min(distance(p1,uv),distance(p2,uv));
    distToControls=min(distance(p3,uv),distToControls);
    distToControls=min(distance(p4,uv),distToControls);
    distToControls=min(distance(p5,uv),distToControls);
    distToControls=min(distance(p6,uv),distToControls);
    distToControls=min(distance(p7,uv),distToControls);
    distToControls=min(distance(p8,uv),distToControls);
    
    if (distToControls<0.02)iterationCol=vec3(0);
    */
    aacol+= iterationCol;
    }
    }
    gl_FragColor=vec4(aacol.xyz/4.,1.);
}






